<?php get_header(); ?>
<section class="page-title-section parallax primary-overlay-solid"
         data-background="<?php echo get_template_directory_uri() ?>/img/advertisers10.png">
    <div class="container lg-container">
        <div class="row">

            <div class="col-md-12 mt-1-8 rtl">
                <ul class="ps-0">
                    <li><a class="text-black" href="<?php echo esc_url(home_url('/')); ?>">خانه</a></li>
                    <?php
                    // Get current category
                    $current_category = get_queried_object();
                    if ($current_category->parent != 0) {
                        $parents = get_category_parents($current_category->parent, true, ' &raquo; ');
                        echo '<li>' . $parents . '</li>';
                    }
                    ?>
                    <li><a class="text-black"
                           href="<?php echo esc_url(get_category_link($current_category)); ?>"><?php single_cat_title(); ?></a>
                    </li>
                </ul>
            </div>

        </div>
    </div>
</section>
<section class="pb-1-9 pt-10">
    <div class="container">
        <div class="row">

            <!-- Blog Right -->
            <div class="col-lg-6">
                <div class="row">
                    <?php
                    // Get current category slug
                    $current_category = get_queried_object();
                    $current_category_slug = $current_category->slug;

                    // Query arguments for blog right
                    $blog_right_args = array(
                        'post_type' => 'post',
                        'category_name' => $current_category_slug, // Use current category slug
                        'posts_per_page' => 4 // تعداد پست‌های مورد نمایش
                    );

                    // The Query for blog right
                    $blog_right_query = new WP_Query($blog_right_args);

                    // The Loop for blog right
                    if ($blog_right_query->have_posts()) {
                        while ($blog_right_query->have_posts()) {
                            $blog_right_query->the_post();
                            ?>
                            <div class="col-lg-6 mb-4">
                                <article class="blog-grid">
                                    <div class="blog-grid-img position-relative"><img class="main-part-img"
                                                                                      alt="<?php the_title_attribute(); ?>"
                                                                                      src="<?php echo get_the_post_thumbnail_url(); ?>">
                                    </div>
                                    <div class="blog-grid-text p-4">
                                        <h3 class="h5 blog-item-title m-0"><a
                                                    href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                    </div>
                                </article>
                            </div>
                            <?php
                        }
                        /* Restore original Post Data */
                        wp_reset_postdata();
                    } else {
                        // no posts found
                    }
                    ?>
                </div>
            </div>
            <!-- End Blog Right -->

            <!-- Blog Left -->
            <div class="col-lg-6 mb-2-9 mb-lg-0">
                <?php
                // Query arguments for blog left
                $blog_left_args = array(
                    'post_type' => 'post',
                    'category_name' => $current_category_slug, // Use current category slug
                    'posts_per_page' => 1 // تنها یک پست نمایش داده شود
                );

                // The Query for blog left
                $blog_left_query = new WP_Query($blog_left_args);

                // The Loop for blog left
                if ($blog_left_query->have_posts()) {
                    while ($blog_left_query->have_posts()) {
                        $blog_left_query->the_post();
                        ?>
                        <div class="blog-list-simple fadeInUp rtl wow" data-wow-delay=".2s">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="blog-list-simple-img"><img
                                                src="<?php echo get_the_post_thumbnail_url(); ?>"
                                                alt="<?php the_title_attribute(); ?>"></div>
                                    <div class="blog-list-simple-text">
                                        <h3 class="text-white"><a
                                                    href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                        <p><?php echo get_the_excerpt() ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php
                    }
                    /* Restore original Post Data */
                    wp_reset_postdata();
                } else {
                    // no posts found
                }
                ?>
            </div>
            <!-- End Blog Left -->


        </div>

    </div>
</section>
<section class="pb-1-9 pt-10">
    <div class="container">
        <div class="row">

            <div class="carousel-style1 col-12 product-grid-style">
                <div class="product-grid grid-style-2 control-top owl-carousel owl-theme">
                    <?php
                    // Get current category information
                    $current_category = get_queried_object();

                    // Get category ID or slug
                    $category_id = $current_category->term_id; // Use $current_category->slug; if you want to use category slug

                    // Query arguments for posts in current category
                    $category_posts_args = array(
                        'post_type' => 'post',
                        'cat' => $category_id,
                        'posts_per_page' => -1 // Retrieve all posts in the category
                    );

                    // The Query for posts in current category
                    $category_posts_query = new WP_Query($category_posts_args);

                    // The Loop for posts in current category
                    if ($category_posts_query->have_posts()) {
                        while ($category_posts_query->have_posts()) {
                            $category_posts_query->the_post();
                            ?>
                            <div>
                                <article class="blog-grid">
                                    <div class="blog-grid-img position-relative"><img class="main-part-img"
                                                                                      alt="<?php the_title_attribute(); ?>"
                                                                                      src="<?php echo get_the_post_thumbnail_url(); ?>">
                                    </div>
                                    <div class="blog-grid-text p-4">
                                        <span class="blog-item-category"><?php the_category(', '); ?></span>
                                        <h3 class="h5 blog-item-title"><a
                                                    href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                        <span class="blog-item-date"><?php echo get_the_date('j F Y'); ?></span>
                                    </div>
                                </article>
                            </div>
                            <?php
                        }
                        /* Restore original Post Data */
                        wp_reset_postdata();
                    } else {
                        // no posts found
                    }
                    ?>
                </div>
            </div>

        </div>

    </div>
</section>

<?php get_footer(); ?>
