<?php /* Template name: تعرفه تبلیغات  */ ?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">

<head>
    <meta http-equiv="Content-Type" content="text/html;charset=UTF-8">

    <title>
        <?php bloginfo('name');
        if (is_front_page()) {
            echo " | ";
            bloginfo('description');
        } else {
            wp_title('|', true, 'left');
        }   ?>
    </title>
    <link type="text/css" href="<?php echo get_template_directory_uri() ?>/assets/css/style-price.css" rel="stylesheet">
    <link type="text/css" href="<?php echo get_template_directory_uri() ?>/assets/css/inner-style.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.rtl.min.css" integrity="sha384-WJUUqfoMmnfkBLne5uxXj+na/c7sesSJ32gI7GfCk4zO4GthUKhSEGyvQ839BC51" crossorigin="anonymous">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js" integrity="sha512-GsLlZN/3F2ErC5ifS5QtgpiJtWd43JWSuIgh7mbzZ8zBps+dvLusV+eNQATqgA/HdeKFVgA5v3S/cIrLF7QnIg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script type="text/javascript" src="https://unpkg.com/xlsx@0.15.1/dist/xlsx.full.min.js"></script>

</head>

<body class="p-3 text-light" style="font-family:Ham3D_Medium !important;">

    <div class="container-fluid">
        <div class="row">
            <div class="col blockquote">
                <p>دسته بندی رسانه ها بر اساس نوع سرویس</p>
            </div>
            <div class="col">
                <div class="row justify-content-end">
                    <div class="col-2 p-0">
                        <p><b> نسخه لیست</b></p>
                    </div>
                    <div class="col-2">
                        <p class="p3 mr-3 text-center text-dark rounded-2" style="background: #9fdbf3;"><?php the_field('version'); ?></p>
                    </div>
                </div>
                <div class="row justify-content-end">
                    <div class="col-2 p-0">
                        <p><b> دریافت خروجی </b></p>
                    </div>
                    <div class="col-2">
                        <div class="row rounded-2">
                            <div class="col-6"><button id="download-button" class="text-center rounded-2 border-0" style="background: #9fdbf3;" onclick="generatePDF()">PDF</button></div>
                            <div class="col-6"><button id="button" class="text-center rounded-2 border-0" style="background: #9fdbf3;" onclick="htmlTableToExcel('xlsx')">EXL</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

    </div>
    <hr />
	<div id="tbl" class="container">
    <div class="row">
        <div class="col">
            <div id="filters" class="pt-5 pb-0">
                <button class="btn works-filter flex-grow-1 showAll works-filter-active" data-filter="all"> همه</button>
                <button class="btn works-filter flex-grow-1" data-filter="prerole"> پری رول</button>
                <button class="btn works-filter" data-filter="smoothy"> اسموتی</button>
                <button class="btn works-filter" data-filter="overlay"> اورلی بنر</button>
                <button class="btn works-filter" data-filter="simple"> بنر عادی</button>
                <button class="btn works-filter" data-filter="notif"> نوتیف ویدیویی</button>
            </div>
			<div class="col table-responsive">
            <table  class="bg-dark bg-gradient table text-center w-100 d-block d-md-table mt-5 text-light ">
                <thead class="table-secondary">
                    <tr>
                        <th style="" scope="col">ردیف</th>
                        <th style="" scope="col">نام</th>
                        <th style="" scope="col">آدرس سایت</th>
                        <th style="" scope="col">دسته بندی</th>
                        <th width="" scope="col">پری رول</th>
                        <th width="" scope="col">اسموتی</th>
                        <th width="" scope="col">اورلی بنر</th>
                        <th width="" scope="col">بنر عادی</th>
                        <th width="" scope="col">نوتیف ویدیویی</th>
                    </tr>
                </thead>
                <tbody>

                    <?php if (have_rows('mediatbl')) {

                        function filter_classes()
                        {
                            $prerole = get_sub_field('prerole');
                            $smoothy = get_sub_field('smoothy');
                            $overlay = get_sub_field('overlay');
                            $simple = get_sub_field('simple');
                            $videonotif = get_sub_field('videonotif');

                            if ($prerole == false) {
                                echo '';
                            } else {
                                echo 'prerole ';
                            }
                            if ($smoothy == false) {
                                echo '';
                            } else {
                                echo 'smoothy ';
                            }
                            if ($overlay == false) {
                                echo '';
                            } else {
                                echo 'overlay ';
                            }
                            if ($simple == false) {
                                echo '';
                            } else {
                                echo 'simple ';
                            }
                            if ($videonotif == false) {
                                echo '';
                            } else {
                                echo 'notif ';
                            }
                        }
                    }
                    ?>
                    <?php if (have_rows('mediatbl')) :
                        // Loop through rows.
                        while (have_rows('mediatbl')) : the_row();

                    ?>

                            <tr class="workItem show-workItem <?php filter_classes(); ?>">
                                <th scope="row" class="align-middle"><?php echo ($c += 1); ?> </th>
                                <td class="align-middle"><img class="img-fluid rounded bg-light" width="25%" src="<?php $image = get_sub_field('logomedia');
                                                                                                    echo esc_url($image['url']); ?>"><span> | </span><?php echo get_sub_field('medianame'); ?></td>
                                <td class="align-middle"><?php echo get_sub_field('mediaurl'); ?></td>
                                <td class="align-middle"><?php echo get_sub_field('categorymedia'); ?></td>

                                <td class="align-middle"><?php $getval = get_sub_field('prerole');
                                                            if ($getval == true) {
                                                            ?>
                                        <img style="background:lightgray; border-radius:3px;" class="img-fluid" src="<?php echo get_template_directory_uri() ?>/assets/images/tick.png"><br>


                                        <div style="cursor: pointer;" class="container text-right mt-3 p-0">
                                            <?php $cnt += 1 ?>
                                            <a class="" class="img-fluid" data-bs-toggle="modal" data-bs-target="#myModal<?php echo $cnt ?>"><img class="img-fluid" src="<?php echo get_template_directory_uri() ?>/assets/images/eye.png"></a>
                                        </div>

                                        <!-- The Modal -->
                                        <div class="modal" id="myModal<?php echo $cnt ?>">
                                            <div class="modal-dialog">
                                                <div class="modal-content">

                                                    <!-- Modal Header -->
                                                    <div class="modal-header">
                                                        <h4 class="modal-title text-dark"> تعرفه تبلیغات پری رول در <?php echo get_sub_field('medianame') ?></h4>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                    </div>

                                                    <!-- Modal body -->
                                                    <div class="modal-body text-center">
                                                        <img class="thumbnail zoom img-fluid" src="<?php echo  get_sub_field('prerole-price'); ?>">
                                                    </div>

                                                    <!-- Modal footer -->
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal">بستن</button>
                                                    </div>

                                                </div>
                                            </div>
                                        </div>




                                    <?php } else {
                                    ?>
<img style="background:lightgray; border-radius:3px;" class="img-fluid" src="<?php echo get_template_directory_uri() ?>/assets/images/notick.png"><br><img class="mt-3 img-fluid" src="<?php echo get_template_directory_uri() ?>/assets/images/no.png">

                                    <?php } ?>
                                </td>

                                <td class="align-middle"><?php $getval = get_sub_field('smoothy');
                                                            if ($getval == true) {
                                                            ?>
                                        <img style="background:lightgray; border-radius:3px;" class="img-fluid" src="<?php echo get_template_directory_uri() ?>/assets/images/tick.png"><br>


                                        <div style="cursor: pointer;" class="container text-right mt-3 p-0">
                                            <?php $cnt += 1 ?>
                                            <a class="" width="25%" data-bs-toggle="modal" data-bs-target="#myModal<?php echo $cnt ?>"><img class="img-fluid" src="<?php echo get_template_directory_uri() ?>/assets/images/eye.png"></a>
                                        </div>

                                        <!-- The Modal -->
                                        <div class="modal" id="myModal<?php echo $cnt ?>">
                                            <div class="modal-dialog">
                                                <div class="modal-content">

                                                    <!-- Modal Header -->
                                                    <div class="modal-header">
                                                        <h4 class="modal-title text-dark"> تعرفه تبلیغات اسموتی در <?php echo get_sub_field('medianame') ?></h4>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                    </div>

                                                    <!-- Modal body -->
                                                    <div class="modal-body text-center">
                                                        <img class="thumbnail zoom img-fluid" src="<?php echo  get_sub_field('smoothy-price'); ?>">
                                                    </div>

                                                    <!-- Modal footer -->
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal">بستن</button>
                                                    </div>

                                                </div>
                                            </div>
                                        </div>

                                    <?php } else {
                                    ?>
<img style="background:lightgray; border-radius:3px; " class="img-fluid" src="<?php echo get_template_directory_uri() ?>/assets/images/notick.png"><br><img  class="mt-3 img-fluid" src="<?php echo get_template_directory_uri() ?>/assets/images/no.png">
                                    <?php } ?>
                                </td>

                                <td class="align-middle"><?php $getval = get_sub_field('overlay');
                                                            if ($getval == true) {
                                                            ?>
                                        <img style="background:lightgray; border-radius:3px;" class="img-fluid" src="<?php echo get_template_directory_uri() ?>/assets/images/tick.png"><br>


                                        <div style="cursor: pointer;" class="container text-right mt-3 p-0">
                                            <?php $cnt += 1 ?>
                                            <a class="" width="25%" data-bs-toggle="modal" data-bs-target="#myModal<?php echo $cnt ?>"><img class="img-fluid" src="<?php echo get_template_directory_uri() ?>/assets/images/eye.png"></a>
                                        </div>

                                        <!-- The Modal -->
                                        <div class="modal" id="myModal<?php echo $cnt ?>">
                                            <div class="modal-dialog">
                                                <div class="modal-content">

                                                    <!-- Modal Header -->
                                                    <div class="modal-header">
                                                        <h4 class="modal-title text-dark"> تعرفه تبلیغات اورلی در<?php echo get_sub_field('medianame') ?></h4>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                    </div>

                                                    <!-- Modal body -->
                                                    <div class="modal-body text-center">
                                                        <img class="thumbnail zoom img-fluid" src="<?php echo  get_sub_field('overlay-price'); ?>">
                                                    </div>

                                                    <!-- Modal footer -->
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal">بستن</button>
                                                    </div>

                                                </div>
                                            </div>
                                        </div>

                                    <?php } else {
                                    ?>
<img style="background:lightgray; border-radius:3px;" class="img-fluid" src="<?php echo get_template_directory_uri() ?>/assets/images/notick.png"><br><img class="mt-3 img-fluid" src="<?php echo get_template_directory_uri() ?>/assets/images/no.png">
                                    <?php } ?>
                                </td>
                                <td class="align-middle">
                                    <?php $getval = get_sub_field('simple');
                                    if ($getval == true) {
                                    ?>
                                        <img style="background:lightgray; border-radius:3px;" class="img-fluid" src="<?php echo get_template_directory_uri() ?>/assets/images/tick.png"><br>


                                        <div style="cursor: pointer;" class="container text-right mt-3 p-0">
                                            <?php $cnt += 1 ?>
                                            <a data-bs-toggle="modal" data-bs-target="#myModal<?php echo $cnt ?>"><img class="img-fluid" src="<?php echo get_template_directory_uri() ?>/assets/images/eye.png"></a>
                                        </div>

                                        <!-- The Modal -->
                                        <div class="modal" id="myModal<?php echo $cnt ?>">
                                            <div class="modal-dialog">
                                                <div class="modal-content">

                                                    <!-- Modal Header -->
                                                    <div class="modal-header">
                                                        <h4 class="modal-title text-dark"> تعرفه تبلیغات بنر عادی در<?php echo get_sub_field('medianame') ?></h4>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                    </div>

                                                    <!-- Modal body -->
                                                    <div class="modal-body text-center">
                                                        <img class="thumbnail zoom img-fluid" src="<?php echo  get_sub_field('simple-price'); ?>">
                                                    </div>

                                                    <!-- Modal footer -->
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal">بستن</button>
                                                    </div>

                                                </div>
                                            </div>
                                        </div>

                                    <?php } else {
                                    ?>

                                        <img style="background:lightgray; border-radius:3px;" class="img-fluid" src="<?php echo get_template_directory_uri() ?>/assets/images/notick.png"><br><img class="mt-3 img-fluid" src="<?php echo get_template_directory_uri() ?>/assets/images/no.png">

                                    <?php } ?>
                                </td>

                                <td class="align-middle">
                                    <?php $getval = get_sub_field('videonotif');


                                    if ($getval == true) {
                                    ?>
                                        <img style="background:lightgray; border-radius:3px;" class="img-fluid" src="<?php echo get_template_directory_uri() ?>/assets/images/tick.png"><br>


                                        <div style="cursor: pointer;" class="container text-right mt-3 p-0">
                                            <?php $cnt += 1 ?>
                                            <a class="" width="25%" data-bs-toggle="modal" data-bs-target="#myModal<?php echo $cnt ?>"><img class="img-fluid" src="<?php echo get_template_directory_uri() ?>/assets/images/eye.png"></a>
                                        </div>

                                        <!-- The Modal -->
                                        <div class="modal" id="myModal<?php echo $cnt ?>">
                                            <div class="modal-dialog">
                                                <div class="modal-content">

                                                    <!-- Modal Header -->
                                                    <div class="modal-header">
                                                        <h4 class="modal-title text-dark"> تعرفه تبلیغات اسموتی در <?php echo get_sub_field('medianame') ?></h4>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                    </div>

                                                    <!-- Modal body -->
                                                    <div class="modal-body text-center">
                                                        <img class="thumbnail zoom img-fluid" src="<?php echo  get_sub_field('notif-price'); ?>">
                                                    </div>

                                                    <!-- Modal footer -->
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal">بستن</button>
                                                    </div>

                                                </div>
                                            </div>
                                        </div>

                                    <?php } else {
                                    ?>
<img style="background:lightgray; border-radius:3px; " class="img-fluid" src="<?php echo get_template_directory_uri() ?>/assets/images/notick.png"><br><img class="mt-3 img-fluid" src="<?php echo get_template_directory_uri() ?>/assets/images/no.png">
                                    <?php } ?>
                                </td>
                            </tr>
                    <?php
                        // End loop.
                        endwhile;
                    // No value.
                    else :
                    // Do something...
                    endif; ?>
                </tbody>
            </table>
        </div>
		</div>
    </div>
	</div>
    <footer class="m-5">
        <div class="container-fluid">
            <div class="row">
                <div class="col">
                    <div class=""><img style="width:15%; float:left;" src="<?php echo get_template_directory_uri() ?>/assets/images/EN-logo.png"></div>
                </div>
                <div class="col">
                    <div class=""><img style="width:15%; float:right;" src="<?php echo get_template_directory_uri() ?>/assets/images/tavoos.png"></div>
                </div>
                <div class="col-12 text-center pt-3 fw-bolder"> تهران، جردن، خیابان مهیار، پلاک 46، واحد 2</div>
                <div class="col-12 text-center pt-1 fw-semibold">0218895632 - 09121234567</div>
            </div>
        </div>
    </footer>

  <!--  <script>
        const button = document.getElementById('download-button');

        function generatePDF() {
            // Choose the element that your content will be rendered to.
            const element = document.getElementById('tbl');
            // Choose the element and save the PDF for your user.
            html2pdf().from(element).save();
        }

        button.addEventListener('click', generatePDF);
    </script> -->
    <script>
        function htmlTableToExcel(type) {
            var data = document.getElementById('tbl');
            var excelFile = XLSX.utils.table_to_book(data, {
                sheet: "sheet1"
            });
            XLSX.write(excelFile, {
                bookType: type,
                bookSST: true,
                type: 'base64'
            });
            XLSX.writeFile(excelFile, 'Prices.xlsx');
        }
    </script>
    <script src="<?php echo get_template_directory_uri() ?>/assets/js/jquery-3.3.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js" integrity="sha384-oBqDVmMz9ATKxIep9tiCxS/Z9fNfEXiDAYTujMAeBAsjFuCZSmKbSSUnQlmh/jp3" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.min.js" integrity="sha384-mQ93GR66B00ZXjt0YO5KlohRA5SY2XofN4zfuZxLkoj1gXtW8ANNCe9d5Y3eG5eD" crossorigin="anonymous"></script>
    <script src="<?php echo get_template_directory_uri() ?>/assets/js/script.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js"></script>
		<script>
			function generatePDF() {
			const element = document.getElementById('tbl');
			var opt = {
				  margin:       0,
				  filename:     'Prices.pdf',
				  image:        { type: 'jpeg', quality: 1 },
				  html2canvas:  { scale: 2 },
				  jsPDF:        { unit: 'in', format: 'a3', orientation: 'landscape' }
				};
				// Choose the element that our invoice is rendered in.
				html2pdf().set(opt).from(element).save();
			}
		</script>
	
	
	<!-- you need to include the shieldui css and js assets in order for the components to work -->
    <!-- <link rel="stylesheet" type="text/css" href="https://www.shieldui.com/shared/components/latest/css/light/all.min.css" />
    <script type="text/javascript" src="https://www.shieldui.com/shared/components/latest/js/shieldui-all.min.js"></script>
    <script type="text/javascript" src="https://www.shieldui.com/shared/components/latest/js/jszip.min.js"></script>

    <script type="text/javascript">
        jQuery(function($) {
            $("#download-button").click(function() {
                // parse the HTML table element having an id=exportTable
                var dataSource = shield.DataSource.create({
                    data: "#tbl",
                    schema: {
                        type: "table",
                        fields: {
                            ردیف: {
                                type: String
                            },
                            نام: {
                                type: String
                            },
                            Email: {
                                type: String
                            }
                        }
                    }
                });

                // when parsing is done, export the data to PDF
                dataSource.read().then(function(data) {
                    var pdf = new shield.exp.PDFDocument({
                        author: "PrepBootstrap",
                        created: new Date()
                    });

                    pdf.addPage("a4", "portrait");

                    pdf.table(
                        50,
                        50,
                        data,
                        [{
                                field: "ردیف",
                                title: "ID",
                                width: 200
                            },
                            {
                                field: "نام",
                                title: "Media name",
                                width: 50
                            },
                            {
                                field: "Email",
                                title: "Email Address",
                                width: 200
                            }
                        ], {
                            margins: {
                                top: 50,
                                left: 50
                            }
                        }
                    );

                    pdf.saveAs({
                        fileName: "PrepBootstrapPDF"
                    });
                });
            });
        });
    </script> -->

</body>

</html>