<?php
get_header();
?>


    <section id="section1" class="inner_page inner_page_inner4">
        <div class="container-fluid section1">
            <div class="inner_page_tools">
                <ul>
                    <li class="back">
                        <!-- Print a link to this category -->
						<?php
						$get_cat       = get_the_category();
						$first_cat     = $get_cat[0];
						$category_name = $first_cat->cat_name;
						$category_link = get_category_link( $first_cat->cat_ID ); ?>
                        <a href="<?php echo esc_url( $category_link ); ?>"
                           title="<?php echo esc_attr( $category_name ); ?>"></a>
                    </li>
                    <li class="next">
						<?php if ( get_adjacent_post( true, '', false, 'category' ) ) {
							next_post_link( '%link', '', $in_same_term = true, $taxonomy = 'category' );
						} else {
							$thiscat = get_the_category();
							$catslug = $thiscat[0]->slug;
							$last    = new WP_Query( array(
								'posts_per_page' => 1,
								'order'          => 'ASC',
								'category_name'  => $catslug
							) );
							$last->the_post();
							echo '<a href="' . get_permalink() . '"></a>';
							wp_reset_postdata();
						}
						?>
                    </li>
                    <li class="prev">
						<?php if ( get_adjacent_post( true, '', true, 'category' ) ) {
							previous_post_link( '%link', '', $in_same_term = true, $taxonomy = 'category' );
						} else {
							$thiscat = get_the_category();
							$catslug = $thiscat[0]->slug;
							$last    = new WP_Query( array(
								'posts_per_page' => 1,
								'order'          => 'desc',
								'category_name'  => $catslug
							) );
							$last->the_post();
							echo '<a href="' . get_permalink() . '"></a>';
							wp_reset_postdata();
						}
						?>
                    </li>


                    <li class="share">
                        <a href="javascript:void(0);"></a>
                        <div class="social_link">
                            <ul>
                                <li class="facebook">
                                    <a href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>"
                                       target="_blank"></a>
                                </li>
                                <li class="twitter">
                                    <a href="https://twitter.com/home?status=<?php the_permalink(); ?>"
                                       target="_blank"></a>
                                </li>
                                <li class="googleplus">
                                    <a href="https://plus.google.com/share?url=<?php the_permalink(); ?>"
                                       target="_blank"></a>
                                </li>
                                <li class="telegram">
                                    <a href="tg://msg?text=<?php the_title(); ?>&url=<?php the_permalink(); ?>"
                                       target="_blank"></a>
                                </li>
                            </ul>
                        </div>
                    </li>

                </ul>
            </div>
        </div>
        <div class="pt"></div>
    </section>
    <main id="main" role="main">
        <div class="news_page">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12 col-sm-12 col-md-10 col-md-offset-1 col-lg-10 col-lg-offset-1">
                        <div class="news_page_single">
                            <h1>
                                <a href="<?php the_permalink(); ?>" class="title"><?php the_title(); ?></a>
                            </h1>
							<?php
							if ( ! has_category( 'service' ) ) { ?>
                                <span class="date"><?php the_date(); ?></span>
							<?php }
							?>
                            <img src="<?php the_post_thumbnail_url(); ?>"
                                 alt="<?php $image_id = get_post_thumbnail_id();
							     get_post_meta( $image_id, '_wp_attachment_image_alt', true ); ?>"
                                 title="<?php get_the_title( $image_id ) ?>">
                            <div class="long-text">
                                <p><?php the_content(); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>


<?php
get_footer();
?>