(function ($, document, undefined) {
    var pluses = /\+/g;
    function raw(s) {
        return s;
    }

    function decoded(s) {
        return decodeURIComponent(s.replace(pluses, ' '));
    }

    var config = $.cookie = function (key, value, options) {

        if (value !== undefined) {
            options = $.extend({}, config.defaults, options);

            if (value === null) {
                options.expires = -1;
            }

            if (typeof options.expires === 'number') {
                var days = options.expires, t = options.expires = new Date();
                t.setDate(t.getDate() + days);
            }

            value = config.json ? JSON.stringify(value) : String(value);

            return (document.cookie = [
                encodeURIComponent(key), '=', config.raw ? value : encodeURIComponent(value),
                options.expires ? '; expires=' + options.expires.toUTCString() : '',
                options.path ? '; path=' + options.path : '',
                options.domain ? '; domain=' + options.domain : '',
                options.secure ? '; secure' : ''
            ].join(''));
        }

        var decode = config.raw ? raw : decoded;
        var cookies = document.cookie.split('; ');
        for (var i = 0, parts; (parts = cookies[i] && cookies[i].split('=')); i++) {
            if (decode(parts.shift()) === key) {
                var cookie = decode(parts.join('='));
                return config.json ? JSON.parse(cookie) : cookie;
            }
        }

        return null;
    };

    config.defaults = {};

    $.removeCookie = function (key, options) {
        if ($.cookie(key, options) !== null) {
            $.cookie(key, null, options);
            return true;
        }
        return false;
    };
})(jQuery, document);


function update_basket() {
    $.ajax({
        type: 'get',
        url: site_url + 'ajax.php?basket',
        dataType: 'json',
        success: function (response) {
            html = '';
            total_count = 0;
            i = 0;
            for (x in response) {
                total_count += parseInt(response[x].count);
                i++;
            }
            $('.basket_link b').html('' + total_count + '');
        }
    });
}

$(function () {
    update_basket();
});

(function ($) {

    $.ham3dBasket = function (options) {

        var defaults = {
            id: '',
            kind: 'new',
            update: 'ok',
            number: 1,
            show_modal: 'ok',
            html: 'سرویس جدید به سبد خرید شما افزوده شد'
        };

        var opts = $.extend(defaults, options);

        function add_basket(opts) {

            if ($.cookie('basket')) {
                basket = $.cookie('basket');
                basket_array = basket.split(',');
                added = 0;
                $.each(basket_array, function (i) {
                    product = basket_array[i].split('-');
                    if (product[0] == opts.id) {
                        new_number = parseInt(product[1]) + parseInt(opts.number);
                        basket_array[i] = opts.id + '-' + new_number;
                        added = 1;
                    }
                });
                if (added == 0) {
                    var product = opts.id + '-' + opts.number;
                    basket_array.push(product);
                }
                basket = basket_array.join(',');
                $.cookie('basket', basket, {expires: 7, path: '/'});
            } else {
                basket = opts.id + '-' + opts.number;
                $.cookie('basket', basket, {expires: 7, path: '/'});
            }
            if (opts.update == 'ok') {
                update_basket();
            }
        }

        function get_basket_number(id) {
            returnval = 0;
            if ($.cookie('basket')) {
                basket = $.cookie('basket');
                basket_array = basket.split(',');
                $.each(basket_array, function (i) {
                    product = basket_array[i].split('-');
                    if (product[0] == opts.id) {
                        returnval = product[1];
                    }
                });
            }
            return returnval;
        }

        if (opts.kind == 'new') {
            add_basket(opts);
            if (opts.show_modal == 'ok') {
//                $('body').ham3dModalbox({
//                    html: '<br><div class="add_popup"><div class="add_popup_content"><span>' + opts.html + '</span></div><a class="add_popup_more" href="#" onclick="$(\'#modalbox-wrap\').fadeOut(); return false;">ادامه خرید</a></div>',
//                    auto: 'ok'
//                }).trigger('click');
            }
        } else if (opts.kind == 'remove') {

            basket = $.cookie('basket');
            basket_array = basket.split(',');

            $.each(basket_array, function (i) {
                if (typeof basket_array[i] != 'undefined') {
                    product = basket_array[i].split('-');
                    if (product[0] == opts.id) {
                        basket_array.splice(i, 1);
                    }
                }
            });

            $.cookie('basket', basket_array.join(","), {expires: 7, path: "/"});
            if (opts.update == 'ok') {
                update_basket();
            }

//            if (opts.show_modal == 'ok') {
//                $('body').ham3dModalbox({
//                    html: '<br /><div class="add_popup"><div class="add_popup_content_remove"><span>محصول از سبد خرید شما حذف شد.</span></div></div>',
//                    auto: 'ok'
//                }).trigger('click');
//            }
        }
    }
})(jQuery);